# 🚀 ReviewPR Deployment Guide for Hosting

## ✅ Pre-Deployment Checklist

### 1. **Hosting Requirements**
- [ ] PHP 8.0 or higher
- [ ] MySQL 5.7 or higher
- [ ] Apache/Nginx web server
- [ ] SSL Certificate (recommended)
- [ ] File upload permissions (755 for directories, 644 for files)

### 2. **Database Setup**
- [ ] Create new MySQL database on hosting
- [ ] Create database user with full privileges
- [ ] Note down: hostname, username, password, database name

### 3. **File Preparation**
- [ ] All PHP files are ready for upload
- [ ] Database schema file (`reviewprcom_db.sql`) is ready
- [ ] `.htaccess` file is configured
- [ ] `assets/` directory and all subdirectories

## 📋 Step-by-Step Deployment

### Step 1: Upload Files
```bash
# Method 1: FTP Upload
1. Connect to your hosting via FTP
2. Upload all files from your dashboard directory
3. Set permissions:
   - Directories: 755
   - Files: 644
   - config.php: 600 (more secure)

# Method 2: cPanel File Manager
1. Go to cPanel → File Manager
2. Upload files to public_html/ or www/
3. Extract if uploaded as ZIP
```

### Step 2: Configure Database
```sql
-- Create database (run in phpMyAdmin or hosting control panel)
CREATE DATABASE your_database_name;
CREATE USER 'your_username'@'localhost' IDENTIFIED BY 'your_password';
GRANT ALL PRIVILEGES ON your_database_name.* TO 'your_username'@'localhost';
FLUSH PRIVILEGES;
```

### Step 3: Import Database Schema
```bash
# In phpMyAdmin:
1. Select your database
2. Go to Import tab
3. Choose reviewprcom_db.sql file
4. Click "Go"
```

### Step 4: Update Configuration
1. Copy `config.php` to `config.php.backup`
2. Update database credentials in `config.php`:
   ```php
   define('DB_HOST', 'your_db_host');
   define('DB_USERNAME', 'your_db_username');
   define('DB_PASSWORD', 'your_db_password');
   define('DB_NAME', 'your_db_name');
   ```

### Step 5: Test Installation
- [ ] Visit your domain
- [ ] Check if homepage loads
- [ ] Test admin login: `/admin_login.php`
- [ ] Test database connections
- [ ] Verify all pages work

## 🔧 Troubleshooting

### Common Issues:
1. **500 Internal Server Error**: Check PHP error logs, file permissions
2. **Database Connection Failed**: Verify database credentials
3. **CSS/JS not loading**: Check file permissions, .htaccess rules
4. **Admin login not working**: Check database import, user creation

### Security Checklist:
- [ ] Change default admin password
- [ ] Update config.php permissions to 600
- [ ] Enable SSL (HTTPS)
- [ ] Set up regular backups
- [ ] Monitor error logs

## 📞 Support

If you encounter issues:
1. Check hosting provider's PHP/MySQL versions
2. Verify file permissions
3. Check error logs in cPanel
4. Test database connectivity

## 🎯 Quick Deploy Commands

After uploading files, run these in your browser:
- `https://yourdomain.com/reset_database.php` - Reset database structure
- `https://yourdomain.com/admin_login.php` - Access admin panel

---

**Note**: Always backup your local files before deploying. Test thoroughly on a staging environment if possible.
